package main

import (
	"bytes"
	"crypto/tls"
	"encoding/base64"
	"fmt"
	"log"
	"net"
	"time"

	"github.com/bradfitz/http2"
)

func main() {
	conn := ServerConnection()

	framer := http2.NewFramer(conn, conn)

	ReadPreface(conn)

	framer.WriteSettings()
	framer.WriteSettingsAck()

	time.Sleep(time.Millisecond * 200)

	// {"Flags":243,"FrameMethod":"RawFrame","FrameType":1,"Payload":"0","StreamID":13}
	framer.WriteRawFrame(http2.FrameType(1), http2.Flags(243), 13, []byte{0})

	fmt.Println("DONE")
}

func ServerConnection() net.Conn {
	host := "0.0.0.0:8000"
	cert, err := tls.LoadX509KeyPair("./localhost1437319773023.pem", "./localhost1437319773023.key")
	if err != nil {
		panic(err)
	}
	config := tls.Config{Certificates: []tls.Certificate{cert}, NextProtos: []string{"h2", "h2-14"}}
	listener, err := tls.Listen("tcp", host, &config)
	fmt.Println("listening on", host)

	if err != nil {
		panic(err)
	}

	conn, err := listener.Accept()
	if err != nil {
		panic(err)
	}
	proto := conn.(*tls.Conn).ConnectionState().NegotiatedProtocol
	log.Println("Negotiated proto", proto)

	if err != nil {
		log.Printf("server: accept: %s", err)
	}
	log.Printf("server: accepted from %s", conn.RemoteAddr())

	return conn
}

func ReadPreface(conn net.Conn) (error, bool) {
	buffer := make([]byte, len(http2.ClientPreface))
	n, err := conn.Read(buffer)
	if err != nil {
		return err, false
	}
	return nil, bytes.Compare([]byte(http2.ClientPreface), buffer[:n]) == 0
}

func FromBase64(in string) []byte {
	data, err := base64.StdEncoding.DecodeString(in)
	if err != nil {
		panic(err)
	}
	return data
}
